<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class CacheModules extends Command
{
    protected $signature = 'module:cache';
    protected $description = 'Cache minimal module info for fast loading';

    public function handle()
    {
        $modulesPath = base_path('app/Modules');
        $cachePath = storage_path('framework/cache/modules.php');
        $modules = [];

        if (File::exists($modulesPath)) {
            foreach (File::directories($modulesPath) as $folder) {
                $moduleJsonPath = $folder . '/module.json';
                if (File::exists($moduleJsonPath)) {
                    $data = json_decode(File::get($moduleJsonPath), true);
                    if ($data && isset($data['slug']) && isset($data['providers'])) {
                        $modules[$data['slug']] = [
                            'enabled' => $data['enabled'] ?? true,
                            'providers' => $data['providers'],
                        ];
                    }
                }
            }
        }

        File::put($cachePath, '<?php return ' . var_export($modules, true) . ';');
        $this->info('Modules cached successfully (minimal info).');
    }
}
