<?php

namespace App\Core\Database\Seeders;

use Illuminate\Database\Seeder;
use App\Core\Models\Tenant;
use App\Core\Models\Module;
use App\Core\Models\Version;

class CoreSeeder extends Seeder
{
    public function run(): void
    {
        $tenant = Tenant::create([
            'name' => 'Default Tenant',
            'domain' => 'default.local',
        ]);

        Module::create([
            'tenant_id' => $tenant->id,
            'name' => 'Core',
            'version' => '1.0.0',
            'enabled' => true,
        ]);

        Version::create([
            'module_name' => 'Core',
            'version' => '1.0.0',
            'changelog' => 'Initial release of Core module.'
        ]);
    }
}
