<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyPlan extends Model
{
    protected $table = 'company_plans';

    protected $fillable = [
        'name',
        'price_monthly',
        'price_yearly',
        'description',
        'features',
        'is_active',
    ];

    protected $casts = [
        'price_monthly' => 'decimal:2',
        'price_yearly' => 'decimal:2',
        'is_active' => 'boolean',
        'features' => 'array',
    ];
}
