<?php
use Illuminate\Support\Facades\Route;
use App\Modules\AccessControl\Http\Controllers\AccessControlController;

Route::prefix('access-control')->group(function () {
    // Module status
    Route::get('status', [AccessControlController::class, 'status']);

    // Roles & Permissions
    Route::get('roles', [AccessControlController::class, 'roles']);
    Route::get('permissions', [AccessControlController::class, 'permissions']);

    // Users CRUD
    Route::get('users', [AccessControlController::class, 'index']);           // List all users
    Route::get('users/{id}', [AccessControlController::class, 'show']);       // Get single user
    Route::post('users', [AccessControlController::class, 'store']);          // Create user
    Route::put('users/{id}', [AccessControlController::class, 'update']);    // Update user
    Route::delete('users/{id}', [AccessControlController::class, 'destroy']); // Delete user
});
