<?php

namespace App\Core\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class Voucher extends Model
{
    protected $table = 'vouchers';

    protected $fillable = [
        'uuid',
        'company_id',
        'branch_id',
        'reference',
        'description',
        'voucher_date',
        'total_debit',
        'total_credit',
        'is_synced'
    ];

    public function lines()
    {
        return $this->hasMany(VoucherLine::class);
    }
}
