<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Analytics\Http\Controllers\AnalyticsController;

Route::prefix('analytics')->group(function () {
    Route::get('/test', [AnalyticsController::class, 'test']); // test route
    Route::get('/reports', [AnalyticsController::class, 'index']); // list reports
    Route::get('/reports/{id}', [AnalyticsController::class, 'show']); // show report
    Route::post('/reports', [AnalyticsController::class, 'store']); // create report
    Route::put('/reports/{id}', [AnalyticsController::class, 'update']); // update report
    Route::delete('/reports/{id}', [AnalyticsController::class, 'destroy']); // delete report
});
