<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Automation\Http\Controllers\AutomationController;

Route::prefix('automation')->group(function () {
    Route::get('/test', [AutomationController::class, 'test']); // test route
    Route::get('/tasks', [AutomationController::class, 'index']); // list tasks
    Route::get('/tasks/{id}', [AutomationController::class, 'show']); // show task
    Route::post('/tasks', [AutomationController::class, 'store']); // create task
    Route::put('/tasks/{id}', [AutomationController::class, 'update']); // update task
    Route::delete('/tasks/{id}', [AutomationController::class, 'destroy']); // delete task
});
