<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Billing\Http\Controllers\BillingController;

Route::prefix('billing')->group(function () {
    Route::get('/test', [BillingController::class, 'test']); // test route
    Route::get('/invoices', [BillingController::class, 'index']); // list invoices
    Route::get('/invoices/{id}', [BillingController::class, 'show']); // show invoice
    Route::post('/invoices', [BillingController::class, 'store']); // create invoice
    Route::put('/invoices/{id}', [BillingController::class, 'update']); // update invoice
    Route::delete('/invoices/{id}', [BillingController::class, 'destroy']); // delete invoice
});
