<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Branch\Http\Controllers\BranchController;

Route::prefix('branch')->group(function () {
    Route::get('/test', [BranchController::class, 'test']); // test route
    Route::get('/all', [BranchController::class, 'index']); // list all branches
    Route::get('/{id}', [BranchController::class, 'show']); // show branch
    Route::post('/', [BranchController::class, 'store']); // create branch
    Route::put('/{id}', [BranchController::class, 'update']); // update branch
    Route::delete('/{id}', [BranchController::class, 'destroy']); // delete branch
});
