<?php

use Illuminate\Support\Facades\Route;
use App\Modules\CRM\Http\Controllers\CRMController;

Route::prefix('crm')->group(function () {
    Route::get('/test', [CRMController::class, 'test']); // test route
    Route::get('/customers', [CRMController::class, 'index']); // list customers
    Route::get('/customers/{id}', [CRMController::class, 'show']); // show customer
    Route::post('/customers', [CRMController::class, 'store']); // create customer
    Route::put('/customers/{id}', [CRMController::class, 'update']); // update customer
    Route::delete('/customers/{id}', [CRMController::class, 'destroy']); // delete customer
});
