<?php

use Illuminate\Support\Facades\Route;
use App\Modules\DomainManager\Http\Controllers\DomainManagerController;

Route::prefix('domain')->group(function () {
    Route::get('/test', [DomainManagerController::class, 'test']); // test route
    Route::get('/all', [DomainManagerController::class, 'index']); // list all domains
    Route::get('/{id}', [DomainManagerController::class, 'show']); // show single domain
    Route::post('/', [DomainManagerController::class, 'store']); // add domain
    Route::put('/{id}', [DomainManagerController::class, 'update']); // update domain
    Route::delete('/{id}', [DomainManagerController::class, 'destroy']); // delete domain
});
