<?php

use Illuminate\Support\Facades\Route;
use App\Modules\FieldForce\Http\Controllers\FieldForceController;

Route::prefix('fieldforce')->group(function () {
    Route::get('/test', [FieldForceController::class, 'test']); // test route
    Route::get('/agents', [FieldForceController::class, 'index']); // list all agents
    Route::get('/agents/{id}', [FieldForceController::class, 'show']); // show single agent
    Route::post('/agents', [FieldForceController::class, 'store']); // add agent
    Route::put('/agents/{id}', [FieldForceController::class, 'update']); // update agent
    Route::delete('/agents/{id}', [FieldForceController::class, 'destroy']); // delete agent
});
