<?php

namespace App\Modules\Installment\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class InstallmentController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Installment module is working']);
    }

    // List all installment plans (sample data)
    public function index()
    {
        $plans = [
            ['id' => 1, 'name' => 'Plan A', 'amount' => 1000, 'installments' => 5],
            ['id' => 2, 'name' => 'Plan B', 'amount' => 5000, 'installments' => 10],
        ];

        return response()->json($plans);
    }

    // Show single plan
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Plan',
            'amount' => 2000,
            'installments' => 4,
            'payments' => [
                ['installment' => 1, 'amount' => 500, 'status' => 'paid'],
                ['installment' => 2, 'amount' => 500, 'status' => 'pending'],
            ]
        ]);
    }

    // Create plan
    public function store(Request $request)
    {
        $data = $request->only(['name', 'amount', 'installments']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Installment plan created', 'plan' => $data], 201);
    }

    // Update plan
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'amount', 'installments']);
        return response()->json(['message' => "Installment plan {$id} updated", 'plan' => $data]);
    }

    // Delete plan
    public function destroy($id)
    {
        return response()->json(['message' => "Installment plan {$id} deleted"]);
    }
}
