<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Manufacturing\Http\Controllers\ManufacturingController;

Route::prefix('manufacturing')->group(function () {
    Route::get('/test', [ManufacturingController::class, 'test']); // test route
    Route::get('/orders', [ManufacturingController::class, 'index']); // list all production orders
    Route::get('/orders/{id}', [ManufacturingController::class, 'show']); // show single order
    Route::post('/orders', [ManufacturingController::class, 'store']); // create new production order
    Route::put('/orders/{id}', [ManufacturingController::class, 'update']); // update order
    Route::delete('/orders/{id}', [ManufacturingController::class, 'destroy']); // delete order
});
