<?php

namespace App\Modules\OnlineStore\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class OnlineStoreController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'OnlineStore module is working']);
    }

    // List all products (sample data)
    public function index()
    {
        $products = [
            ['id' => 1, 'name' => 'Laptop', 'price' => 1200, 'stock' => 10, 'category' => 'Electronics'],
            ['id' => 2, 'name' => 'Smartphone', 'price' => 800, 'stock' => 20, 'category' => 'Electronics'],
        ];

        return response()->json($products);
    }

    // Show single product
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Laptop',
            'price' => 1200,
            'stock' => 10,
            'category' => 'Electronics',
            'description' => 'High performance laptop',
        ]);
    }

    // Create new product
    public function store(Request $request)
    {
        $data = $request->only(['name', 'price', 'stock', 'category', 'description']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Product created', 'product' => $data], 201);
    }

    // Update product
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'price', 'stock', 'category', 'description']);
        return response()->json(['message' => "Product {$id} updated", 'product' => $data]);
    }

    // Delete product
    public function destroy($id)
    {
        return response()->json(['message' => "Product {$id} deleted"]);
    }
}
