<?php

use Illuminate\Support\Facades\Route;
use App\Modules\OnlineStore\Http\Controllers\OnlineStoreController;

Route::prefix('online-store')->group(function () {
    Route::get('/test', [OnlineStoreController::class, 'test']); // test route
    Route::get('/products', [OnlineStoreController::class, 'index']); // list all products
    Route::get('/products/{id}', [OnlineStoreController::class, 'show']); // show single product
    Route::post('/products', [OnlineStoreController::class, 'store']); // create new product
    Route::put('/products/{id}', [OnlineStoreController::class, 'update']); // update product
    Route::delete('/products/{id}', [OnlineStoreController::class, 'destroy']); // delete product
});
