<?php

use Illuminate\Support\Facades\Route;
use App\Modules\ProjectManagement\Http\Controllers\ProjectManagementController;

Route::prefix('projects')->group(function () {
    Route::get('/test', [ProjectManagementController::class, 'test']); // test route
    Route::get('/', [ProjectManagementController::class, 'index']); // list all projects
    Route::get('/{id}', [ProjectManagementController::class, 'show']); // show single project
    Route::post('/', [ProjectManagementController::class, 'store']); // create new project
    Route::put('/{id}', [ProjectManagementController::class, 'update']); // update project
    Route::delete('/{id}', [ProjectManagementController::class, 'destroy']); // delete project
});
