<?php

namespace App\Modules\SeedFarming\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SeedFarmingController extends Controller
{
    public function index()
    {
        return response()->json([
            'status' => 'success',
            'farms' => [
                ['id' => 1, 'crop' => 'Wheat', 'status' => 'Growing'],
                ['id' => 2, 'crop' => 'Corn', 'status' => 'Ready to Harvest'],
            ]
        ]);
    }

    public function plant(Request $request)
    {
        $data = $request->only(['crop', 'area']);
        // Example: Save to database here

        return response()->json([
            'status' => 'success',
            'message' => "Planted {$data['crop']} on {$data['area']} acres",
            'details' => $data
        ]);
    }

    public function harvest(Request $request)
    {
        $data = $request->only(['farm_id']);
        // Example: Harvest logic here

        return response()->json([
            'status' => 'success',
            'message' => "Harvested farm ID {$data['farm_id']}"
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'SeedFarming module is working!']);
    }
}
