<?php

namespace App\Modules\TailorManagement\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TailorManagementController extends Controller
{
    private $tailors = [
        ['id' => 1, 'name' => 'John Doe', 'specialty' => 'Suits'],
        ['id' => 2, 'name' => 'Jane Smith', 'specialty' => 'Dresses'],
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'tailors' => $this->tailors
        ]);
    }

    public function addTailor(Request $request)
    {
        $data = $request->only(['name', 'specialty']);
        $data['id'] = count($this->tailors) + 1;
        $this->tailors[] = $data;

        return response()->json([
            'status' => 'success',
            'message' => 'New tailor added successfully',
            'tailor' => $data
        ]);
    }

    public function updateTailor(Request $request)
    {
        $data = $request->only(['id', 'name', 'specialty']);

        foreach ($this->tailors as &$tailor) {
            if ($tailor['id'] == $data['id']) {
                $tailor['name'] = $data['name'] ?? $tailor['name'];
                $tailor['specialty'] = $data['specialty'] ?? $tailor['specialty'];
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => "Tailor ID {$data['id']} updated",
            'tailors' => $this->tailors
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'TailorManagement module is working!']);
    }
}
