<?php

namespace App\Modules\TaxIntegration\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TaxIntegrationController extends Controller
{
    private $taxRates = [
        'standard' => 0.1, // 10%
        'reduced' => 0.05  // 5%
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'taxRates' => $this->taxRates
        ]);
    }

    public function calculateTax(Request $request)
    {
        $amount = $request->input('amount', 0);
        $type = $request->input('type', 'standard');

        $rate = $this->taxRates[$type] ?? 0;

        $tax = $amount * $rate;
        $total = $amount + $tax;

        return response()->json([
            'status' => 'success',
            'amount' => $amount,
            'tax' => $tax,
            'total' => $total,
            'type' => $type
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'TaxIntegration module is working!']);
    }
}
