<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ----------------------
        // Payroll Table
        // ----------------------
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('hrm_employees')->cascadeOnDelete();
            $table->date('pay_month'); // Month of payroll, e.g., 2025-11-01
            $table->decimal('basic_salary', 15,2)->default(0);
            $table->decimal('allowances', 15,2)->default(0);
            $table->decimal('bonus', 15,2)->default(0);
            $table->decimal('deductions', 15,2)->default(0);
            $table->decimal('leave_deduction', 15,2)->default(0);
            $table->decimal('half_day_deduction', 15,2)->default(0);
            $table->decimal('overtime_pay', 15,2)->default(0);
            $table->decimal('net_salary', 15,2)->default(0);
            $table->enum('status', ['pending','paid','rejected'])->default('pending');
            $table->timestampsTz();
        });

        // ----------------------
        // Payroll Adjustments (optional)
        // ----------------------
        Schema::create('payroll_adjustments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payroll_id')->constrained('payrolls')->cascadeOnDelete();
            $table->string('adjustment_type'); // fine, bonus, deduction
            $table->decimal('amount', 15,2);
            $table->text('remarks')->nullable();
            $table->timestampsTz();
        });

        // ----------------------
        // Payslip PDF / history (optional)
        // ----------------------
        Schema::create('payroll_payslips', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payroll_id')->constrained('payrolls')->cascadeOnDelete();
            $table->string('file_path'); // stored PDF path
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payroll_payslips');
        Schema::dropIfExists('payroll_adjustments');
        Schema::dropIfExists('payrolls');
    }
};
