<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ----------------------
        // Clients
        // ----------------------
        Schema::create('pm_clients', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('contact_person')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->timestampsTz();
        });

        // ----------------------
        // Projects
        // ----------------------
        Schema::create('pm_projects', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('client_id')->nullable(); // removed FK
            $table->text('description')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->decimal('budget', 15,2)->default(0);
            $table->enum('status', ['planning','in_progress','on_hold','completed','cancelled'])->default('planning');
            $table->timestampsTz();
        });

        // ----------------------
        // Project Users / Team
        // ----------------------
        Schema::create('pm_project_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id'); // removed FK
            $table->unsignedBigInteger('user_id'); // removed FK
            $table->enum('role',['manager','developer','tester','designer','client'])->default('developer');
            $table->timestampsTz();
            $table->unique(['project_id','user_id']);
        });

        // ----------------------
        // Milestones
        // ----------------------
        Schema::create('pm_milestones', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id'); // removed FK
            $table->string('name');
            $table->date('due_date')->nullable();
            $table->enum('status',['pending','completed'])->default('pending');
            $table->timestampsTz();
        });

        // ----------------------
        // Tasks
        // ----------------------
        Schema::create('pm_tasks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id'); // removed FK
            $table->unsignedBigInteger('milestone_id')->nullable(); // removed FK
            $table->string('title');
            $table->text('description')->nullable();
            $table->unsignedBigInteger('assigned_to')->nullable(); // removed FK
            $table->enum('priority',['low','medium','high','critical'])->default('medium');
            $table->enum('status',['pending','in_progress','completed','blocked'])->default('pending');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->decimal('estimated_hours',5,2)->default(0);
            $table->decimal('logged_hours',5,2)->default(0);
            $table->unsignedBigInteger('depends_on')->nullable(); // removed FK
            $table->timestampsTz();
        });

        // ----------------------
        // Task Comments
        // ----------------------
        Schema::create('pm_task_comments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('task_id'); // removed FK
            $table->unsignedBigInteger('user_id'); // removed FK
            $table->text('comment');
            $table->timestampsTz();
        });

        // ----------------------
        // Project Documents / Attachments
        // ----------------------
        Schema::create('pm_project_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id'); // removed FK
            $table->unsignedBigInteger('uploaded_by')->nullable(); // removed FK
            $table->string('file_name');
            $table->string('file_path');
            $table->timestampsTz();
        });

        // ----------------------
        // Expenses / Budget Tracking
        // ----------------------
        Schema::create('pm_project_expenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id'); // removed FK
            $table->string('title');
            $table->decimal('amount',15,2);
            $table->text('remarks')->nullable();
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pm_project_expenses');
        Schema::dropIfExists('pm_project_documents');
        Schema::dropIfExists('pm_task_comments');
        Schema::dropIfExists('pm_tasks');
        Schema::dropIfExists('pm_milestones');
        Schema::dropIfExists('pm_project_users');
        Schema::dropIfExists('pm_projects');
        Schema::dropIfExists('pm_clients');
    }
};
